#if NUNIT

#region References

using System;
using System.Collections;
using System.Text;

using NUnit.Framework;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.DAL.HL7AL;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary;
using gov.va.med.vbecs.DAL.HL7.OpenLibrary.Messages;

using gov.va.med.vbecs.UnitTests;

#endregion

namespace gov.va.med.vbecs.DAL.HL7.UnitTests.OpenLibrary.Messages
{
	[TestFixture]
	public class Messages_HL7OmgMessage : BaseTest
	{
		#region Variables & Setup

		private static string _hl7Message;

		HL7OmgMessage _omgMessage;

		static Messages_HL7OmgMessage()
		{
			_hl7Message = string.Concat(
				"MSH|^~\\&|OERR|589|VBECS|589|20080526135401-0500||OMG^O19|5894312166|T|2.4|||AL|AL|USA",
				CARRIAGE_RETURN,
				"PID|||5890045694V193464^^^^NI~493013508^^^^SS~14161^^^^PI||HALZ^ALUUN^J||19601126|M",
				CARRIAGE_RETURN,
				"PV1||O|KC-1010 NEW PT CLINIC 2|||||||", 
				CARRIAGE_RETURN,
				"ORC|NW|22179410^OR||22179406^OR|||||200805261354-0500|53342^USER^ONE||53342^USER^ONE||||^Transfuse|589^VA HEARTLAND - WEST, VISN 15|||", 
				CARRIAGE_RETURN,
				"OBR|1|22179410^OR||1^TYPE \\T\\ SCREEN^99VBC^^|||||||O||89932;3080526;4;6478||^^SEND PATIENT||||||||||||^^^20080526^200805261354-0500^R^^", 
				CARRIAGE_RETURN,
				"OBX|1||191^ALANINE AMINOTRANSFERASE^99LRT||17|IU/L|8-40||||F|||20020114093059-0500",
				CARRIAGE_RETURN,
				"DG1|1||^^^^^|||A ",
				CARRIAGE_RETURN );
		}

		[SetUp]
		public void SetUp()
		{
			_omgMessage = new HL7OmgMessage( _hl7Message );
		}

		#endregion

		#region Constructors

		[Test]
		public void Ctor_Pass()
		{
			HL7OmgMessage omgMessage = new HL7OmgMessage( _hl7Message );
			//
			Assert.IsTrue( omgMessage != null );
		}

		[Test]
		[ExpectedException( typeof( ArgumentNullException ) )]
		public void Ctor_Fail()
		{
			HL7OmgMessage omgMessage = new HL7OmgMessage( null );
			//
			Assert.IsTrue( omgMessage != null );
		}

		#endregion

		#region Methods

		[Test]
		public void GetMessage_Pass()
		{
			Assert.IsNotNull( _omgMessage.GetMessage() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessage_Fail()
		{
		}

		[Test]
		public void GetMessageControlID_Pass()
		{
			Assert.IsNotNull( _omgMessage.GetMessageControlID() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageControlID_Fail()
		{
		}

		[Test]
		public void GetMessageType_Pass()
		{
			Assert.IsNotNull( _omgMessage.GetMessageType() );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void GetMessageType_Fail()
		{
		}

		[Test]
		public void IsResponseRequired_Pass()
		{
			Assert.IsTrue( _omgMessage.IsResponseRequired() == true );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void IsResponseRequired_Fail()
		{
		}

		#endregion

		#region Properties

		[Test]
		public void Delimiters_Pass()
		{
			Assert.IsNotNull( _omgMessage.Delimiters );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Delimiters_Fail()
		{
		}

		[Test]
		public void Message_Pass()
		{
			Assert.IsNotNull( _omgMessage.Message );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void Message_Fail()
		{
		}

		[Test]
		public void MessageControlID_Pass()
		{
			_omgMessage.MessageControlID = "TEST";
			//
			Assert.IsNotNull( _omgMessage.MessageControlID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageControlID_Fail()
		{
		}

		[Test]
		public void MessageType_Pass()
		{
			Assert.IsNotNull( _omgMessage.MessageType );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MessageType_Fail()
		{
		}

		[Test]
		public void OrderControlCode_Pass()
		{
			Assert.IsNotNull( _omgMessage.OrderControlCode );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OrderControlCode_Fail()
		{
		}

		[Test]
		public void MSH_Pass()
		{
			_omgMessage.MSH = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.MSH );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void MSH_Fail()
		{
		}

		[Test]
		public void PID_Pass()
		{
			_omgMessage.PID = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.PID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PID_Fail()
		{
		}

		[Test]
		public void PV1_Pass()
		{
			_omgMessage.PV1 = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.PV1 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void PV1_Fail()
		{
		}

		[Test]
		public void ORC_Pass()
		{
			_omgMessage.ORC = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.ORC );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void ORC_Fail()
		{
		}

		[Test]
		public void OBR_Pass()
		{
			_omgMessage.OBR = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.OBR );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OBR_Fail()
		{
		}

		[Test]
		public void DG1_Pass()
		{
			_omgMessage.DG1 = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.DG1 );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void DG1_Fail()
		{
		}

		[Test]
		public void NTE_Pass()
		{
			ArrayList nteList = new ArrayList();
			//
			nteList.Add( "TEST" );
			//
			_omgMessage.NTE = nteList;
			//
			Assert.IsNotNull( _omgMessage.NTE );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void NTE_Fail()
		{
		}

		[Test]
		public void OBX_Pass()
		{
			_omgMessage.OBX = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.OBX );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void OBX_Fail()
		{
		}

		[Test]
		public void UniversalServiceID_Pass()
		{
			_omgMessage.UniversalServiceID = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.UniversalServiceID );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void UniversalServiceID_Fail()
		{
		}

		[Test]
		public void TimingQuantity_Pass()
		{
			_omgMessage.TimingQuantity = new string[]{ "TEST" };
			//
			Assert.IsNotNull( _omgMessage.TimingQuantity );
		}

		[Test]
		[Ignore(StandardIgnoreReasons.ReadOnlyProperty)]
		public void TimingQuantity_Fail()
		{
		}

		#endregion
	}
}
#endif